<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = false;

    public function message()
    {
        return $this->hasMany('Message', 'question_id');
    }

    public function choices()
    {
        return $this->hasMany('Choice', 'question_id');
    }

    public function quiz()
    {
        return $this->belongsTo('Quiz', 'quiz_id');
    }

}